// A*TASY̌vZ
Function a_star(fromPointAgt As Agt, toPointAgt As Agt) As String
{
	Dim pointAgtSet As AgtSet, pointAgt As Agt
	Dim openPointAgtSet As AgtSet, closePointAgtSet As AgtSet
	Dim targetPointAgt As Agt, nearPointAgt As Agt
	Dim f_dash As Double
	Dim oneParentPointAgt As Agt
	Dim rtnValue As String
	
	rtnValue = ""
	
	If CInt(fromPointAgt) == CInt(toPointAgt) Then
		// Point̂Ƃ""Ԃ
	Else
		// ϐ̏
		MakeAgtSet(pointAgtSet, Universe.Map.Point)
		For Each pointAgt In pointAgtSet
			pointAgt.g = 0
			pointAgt.f = 0
			pointAgt.ParentPointAgt = pointAgt
		Next pointAgt

		// X^[gm[hOpenXgɒǉ
		AddAgt(openPointAgtSet, fromPointAgt)
		fromPointAgt.ParentPointAgt = fromPointAgt
		fromPointAgt.g = 0
		fromPointAgt.f = get_distance(fromPointAgt, toPointAgt)

		Do While(1)
			// G[`FbN
			If CountAgtSet(openPointAgtSet) == 0 Then
				Break
			End If
			
			// OpenXgōŏRXgtargetPointAgt擾
			SortAgtSet(openPointAgtSet, "f", True)
			targetPointAgt = GetAgt(openPointAgtSet, 0)
			DelAgtSet2(openPointAgtSet, targetPointAgt)
			AddAgt(closePointAgtSet, targetPointAgt)
					
			If CInt(targetPointAgt) == CInt(toPointAgt) Then
				// S[̏ꍇ
				Break
			End If

			// אڂĂPointɑ΂ď
			For Each nearPointAgt In targetPointAgt.NearAgtSet
				// f_dasȟvZ
				nearPointAgt.g = targetPointAgt.g + get_distance(targetPointAgt, nearPointAgt)
				f_dash = nearPointAgt.g + get_distance(nearPointAgt, toPointAgt)
				 
				If (GetAgtEntry(openPointAgtSet, nearPointAgt) == -1) And (GetAgtEntry(closePointAgtSet, nearPointAgt) == -1) Then
					// Ή1FVKPoint̏ꍇ
					nearPointAgt.f = f_dash
					nearPointAgt.ParentPointAgt = targetPointAgt
					AddAgt(openPointAgtSet, nearPointAgt)
				ElseIf GetAgtEntry(openPointAgtSet, nearPointAgt) > -1 Then
					If f_dash < nearPointAgt.f Then		
						// Ή2FVKPoint̏ꍇ
						nearPointAgt.f = f_dash
						nearPointAgt.ParentPointAgt = targetPointAgt
					End If
				ElseIf GetAgtEntry(closePointAgtSet, nearPointAgt) > -1 Then
					If f_dash < nearPointAgt.f Then		
						// Ή3
						nearPointAgt.f = f_dash
						DelAgtSet2(closePointAgtSet, nearPointAgt)
						AddAgt(openPointAgtSet, nearPointAgt)
						nearPointAgt.ParentPointAgt = targetPointAgt
					End If
				End If
			Next pointAgt
		Loop

		// oH̐
		Do While(1)
			If CInt(targetPointAgt) == CInt(fromPointAgt) Then
				Break
			ElseIf Len(rtnValue) == 0 Then
				rtnValue = CStr(targetPointAgt.ID)
			Else
				oneParentPointAgt = targetPointAgt.ParentPointAgt
				rtnValue = CStr(oneParentPointAgt.ID) & "," & rtnValue
				targetPointAgt = targetPointAgt.ParentPointAgt
			End If
		Loop
	End If
	
	// ړInɓBłȂꍇ̓NA
	If CInt(GetToken(rtnValue, CountToken(rtnValue) - 1)) <> toPointAgt.ID Then
		rtnValue = ""
	End If
	
	Return(rtnValue)
}

// 2PointԂ̋擾
Function get_distance(fromPointAgt As Agt, toPointAgt As Agt) As Double
{
	Return(MeasureDistance(fromPointAgt.X, fromPointAgt.Y, toPointAgt.X, toPointAgt.Y, Universe.Map))
}

// t̃Nݒ
Sub set_reverse_link()
{
	Dim linkAgtSet As AgtSet, linkAgt As Agt
	Dim newLinkAgt As Agt
	Dim onePointAgt As Agt, twoPointAgt As Agt
	
	// PointɃNG[WFgo^
	MakeAgtSet(linkAgtSet, Universe.Link)
	For Each linkAgt In linkAgtSet
		onePointAgt = linkAgt.Begin_Agt
		twoPointAgt = linkAgt.End_Agt
		newLinkAgt = CreateAgt(Universe.Link)
		newLinkAgt.Begin_Agt = twoPointAgt
		newLinkAgt.End_Agt = onePointAgt
	Next linkAgt
}

// PointɃNG[WFgo^
Sub set_near_point()
{
	Dim pointAgtSet As AgtSet, pointAgt As Agt
	Dim linkAgtSet As AgtSet, linkAgt As Agt
	Dim onePointAgt As Agt, twoPointAgt As Agt
	
	// PointɃNG[WFgNA
	MakeAgtSet(pointAgtSet, Universe.Map.Point)
	For Each pointAgt In pointAgtSet
		ClearAgtSet(pointAgt.NearAgtSet)
	Next pointAgt
	
	// PointɃNG[WFgo^
	MakeAgtSet(linkAgtSet, Universe.Link)
	For Each linkAgt In linkAgtSet
		onePointAgt = linkAgt.Begin_Agt
		twoPointAgt = linkAgt.End_Agt
		AddAgt(onePointAgt.NearAgtSet, twoPointAgt)
	Next linkAgt
}

// A*TASYŋ߂PointԂ̋
Function a_star_distance(fromPointAgt As Agt, toPointAgt As Agt) As Double
{
	Dim oneRouteArray As String 
	Dim beginPointAgt As Agt, endPointAgt As Agt
	Dim d As Double
	Dim i As Integer
	Dim rtnValue As Double

	rtnValue = 0.0
	
	oneRouteArray = a_star(fromPointAgt, toPointAgt)

	If CountToken(oneRouteArray) >= 2 Then
		For i=0 To CountToken(oneRouteArray) -2
			beginPointAgt = Universe.Map.Point(CInt(GetToken(oneRouteArray, i)))
			endPointAgt = Universe.Map.Point(CInt(GetToken(oneRouteArray, i + 1)))
		
			If 	beginPointAgt.ID <> endPointAgt.ID Then
				// Pointł͂Ȃꍇ
				rtnValue = rtnValue + Sqr((endPointAgt.X - beginPointAgt.X)^2 + (endPointAgt.Y - beginPointAgt.Y)^2)
			End If
		Next i
	End If

	Return(rtnValue)
}

// 2PointԂ̃Nؒf
Sub cut_link(fromPointAgt As Agt, toPointAgt As Agt)
{
	Dim linkAgtSet As AgtSet, linkAgt As Agt
	Dim cutLinkAgtSet As AgtSet
	
	ClearAgtSet(cutLinkAgtSet)
	
	// 
	MakeAgtSet(linkAgtSet, Universe.Link)
	For Each linkAgt In linkAgtSet
		If linkAgt.Begin_Agt == fromPointAgt And linkAgt.End_Agt == toPointAgt Then
			AddAgt(cutLinkAgtSet, linkAgt)
		End If
	Next linkAgt
	
	// t
	MakeAgtSet(linkAgtSet, Universe.Link)
	For Each linkAgt In linkAgtSet
		If linkAgt.Begin_Agt == toPointAgt And linkAgt.End_Agt == fromPointAgt Then
			AddAgt(cutLinkAgtSet, linkAgt)
		End If
	Next linkAgt
	
	// linkAgt폜
	Do While(True)
		If CountAgtSet(cutLinkAgtSet) > 0 Then
			linkAgt = GetAgt(cutLinkAgtSet, 0)
			TerminateAgt(linkAgt)
		Else
			Break
		End If
	Loop
	
	// NPointi[
	set_near_point()
}

// 2PointԂ̃NmF
// @ԂlFTrue ڑĂ AFalse ڑĂȂ
Function check_link(fromPointAgt As Agt, toPointAgt As Agt) As Boolean
{
	Dim linkAgtSet As AgtSet, linkAgt As Agt
	Dim rtnValue As Boolean

	rtnValue = False

	MakeAgtSet(linkAgtSet, Universe.Link)
	For Each linkAgt In linkAgtSet
		If linkAgt.Begin_Agt == fromPointAgt And linkAgt.End_Agt == toPointAgt Then
			rtnValue = True
			Break
		End If
	Next linkAgt

	Return(rtnValue)
}

// 2PointԂ̃N擾
// @ԂlFNIDiڑĂȂꍇ-1j
Function get_link(fromPointAgt As Agt, toPointAgt As Agt) As Integer
{
	Dim linkAgtSet As AgtSet, linkAgt As Agt
	Dim rtnValue As Integer

	rtnValue = -1

	MakeAgtSet(linkAgtSet, Universe.Link)
	For Each linkAgt In linkAgtSet
		If linkAgt.Begin_Agt == fromPointAgt And linkAgt.End_Agt == toPointAgt Then
			rtnValue = linkAgt.ID
			Break
		End If
	Next linkAgt

	Return(rtnValue)
}

// A*TASY̌vZiPointIDŌj
Function a_star_id(fromPointID As Integer, toPointID As Integer) As String
{
	Dim fromPointAgt As Agt, toPointAgt As Agt
	
	fromPointAgt = Universe.Map.Point(fromPointID)
	toPointAgt = Universe.Map.Point(toPointID)

	Return(a_star(fromPointAgt, toPointAgt))
}

// A*TASY̌vZiPointIDŌA̖ړIn̂ł߂ړIňoHTj
Function a_star_id_array(fromPointID As Integer, toPointIDArray As String) As String
{
	Dim targetPointID As Integer, minDistance As Double, tmpDistance As Double, tmpTargetPointID As Integer
	Dim w As Integer, h As Integer
	Dim i As Integer
	
	w = GetWidthSpace(Universe.Map)
	h = GetHeightSpace(Universe.Map)
	
	// ł߂ړIn
	minDistance = Sqr(w^2 + h^2)
	targetPointID = CInt(GetToken(toPointIDArray, 0))
	minDistance = @a_star_distance_id(fromPointID, targetPointID)
	For i=1 To CountToken(toPointIDArray) - 1
		tmpTargetPointID = CInt(GetToken(toPointIDArray, i))
		tmpDistance = @a_star_distance_id(fromPointID, tmpTargetPointID)
		If (tmpDistance <= minDistance) And (tmpDistance) > 0 Then
			minDistance = tmpDistance
			targetPointID = tmpTargetPointID
		End If
	Next i
	
	Return(a_star_id(fromPointID, targetPointID))
}

// A*TASYŋ߂PointԂ̋iPointIDŌj
Function a_star_distance_id(fromPointID As Integer, toPointID As Integer) As Double
{
	Dim fromPointAgt As Agt, toPointAgt As Agt
	
	fromPointAgt = Universe.Map.Point(fromPointID)
	toPointAgt = Universe.Map.Point(toPointID)

	Return(a_star_distance(fromPointAgt, toPointAgt))
}

// 2PointԂ̃NؒfiPointIDŌj
Sub cut_link_id(fromPointID As Integer, toPointID As Integer)
{
	Dim fromPointAgt As Agt, toPointAgt As Agt
	
	fromPointAgt = Universe.Map.Point(fromPointID)
	toPointAgt = Universe.Map.Point(toPointID)
	
	cut_link(fromPointAgt, toPointAgt)
}

// 2PointԂ̃NmFiPointIDŌj
// @ԂlFTrue ڑĂ AFalse ڑĂȂ
Function check_link_id(fromPointID As Integer, toPointID As Integer) As Boolean
{
	Dim fromPointAgt As Agt, toPointAgt As Agt
	
	fromPointAgt = Universe.Map.Point(fromPointID)
	toPointAgt = Universe.Map.Point(toPointID)
	
	Return(check_link(fromPointAgt, toPointAgt))
}

// 2PointԂ̃N擾iPointIDŌj
// @ԂlFNIDiڑĂȂꍇ-1j
Function get_link_id(fromPointID As Integer, toPointID As Integer) As Integer
{
	Dim fromPointAgt As Agt, toPointAgt As Agt
	
	fromPointAgt = Universe.Map.Point(fromPointID)
	toPointAgt = Universe.Map.Point(toPointID)
	
	Return(get_link(fromPointAgt, toPointAgt))
}

